// src/lib/awareness/collective/components/charts/theme.ts
/** خريطة ألوان الاتجاهات الأساسية */
export const trendColorMap = {
  Integrate: 'hsl(160 100% 40%)', // Green
  Reform: 'hsl(25 95% 55%)', // Orange
  Reset: 'hsl(48 95% 55%)', // Yellow
} as const;

/** Formatter لمحور Y يرجع أسماء الاتجاهات بدل الأرقام */
// export const yAxisTickFormatter = (v: number) =>
//   v === 1 ? 'Integrate' : v === 2 ? 'Reform' : v === 3 ? 'Reset' : '';

// /** Formatter لمحور X يحوّل timestamp لتاريخ مختصر */
// export const xAxisTickFormatter = (ts: number) =>
//   new Date(ts).toLocaleDateString('en-US', { month: 'short', day: 'numeric' });

export const xAxisTickFormatter = (t: number) =>
  new Date(t).toLocaleDateString('en-US', { month: 'short', day: 'numeric' });

export const yAxisTickFormatter = (v: number) =>
  v === 1 ? 'Integrate' : v === 2 ? 'Reform' : v === 3 ? 'Reset' : '';
