// import React from 'react';
// import { yAxisTickFormatter } from './theme';

// export const CustomTooltip = ({ active, payload, label }: any) => {
//   if (!active || !payload || !payload.length) return null;
//   const data = payload[0].payload;
//   return (
//     <div className="rounded-lg bg-[hsl(var(--card))] border border-[hsl(var(--border))] p-3 shadow-lg text-sm">
//       <div className="font-semibold mb-1">
//         {new Date(label).toLocaleString()}
//       </div>
//       <div>Trend: {yAxisTickFormatter(data.trendValue)}</div>
//       <div>Confidence: {(data.confidence * 100).toFixed(1)}%</div>
//       <div>Change Rate: {data.changeRate.toFixed(2)}%</div>
//       {data.notes && (
//         <div className="mt-1 text-[hsl(var(--muted-foreground))] italic">
//           {data.notes}
//         </div>
//       )}
//     </div>
//   );
// };

// ================================
import React from 'react';
import { yAxisTickFormatter } from './theme';

export const CustomTooltip = ({ active, payload, label }: any) => {
  if (!active || !payload || !payload.length) return null;
  const data = payload[0].payload;
  const isPrediction = data.isPrediction;

  return (
    <div className="rounded-lg bg-[hsl(var(--card))]/95 border border-[hsl(var(--border))]/60 p-3 shadow-lg text-xs">
      <div className="font-semibold mb-1">
        {isPrediction ? 'Predicted Next Day' : new Date(label).toLocaleString()}
      </div>
      <div>Trend: {yAxisTickFormatter(data.trendValue)}</div>
      <div>Confidence: {(data.confidence * 100).toFixed(1)}%</div>
      <div>Change Rate: {data.changeRate?.toFixed(2) ?? 0}%</div>
      {data.notes && <div className="mt-1 italic opacity-70">{data.notes}</div>}
    </div>
  );
};
