import React from 'react';
import { trendColorMap } from './theme';

export const CustomLegend: React.FC = () => {
  const trends = Object.keys(trendColorMap) as (keyof typeof trendColorMap)[];
  return (
    <div className="flex flex-wrap gap-4 px-4 py-2 text-xs">
      {trends.map((trend) => (
        <div key={trend} className="flex items-center gap-1">
          <span
            className="inline-block w-3 h-3 rounded-sm"
            style={{ background: trendColorMap[trend] }}
          ></span>
          {trend}
        </div>
      ))}
      <div className="flex items-center gap-1">
        <span className="w-8 h-[6px] bg-gradient-to-r from-[hsl(var(--foreground)/0.3)] to-[hsl(var(--foreground))] rounded-sm"></span>
        Confidence →
      </div>
    </div>
  );
};
