import React from 'react';
import { trendColorMap } from './theme';

interface Props {
  cx?: number;
  cy?: number;
  payload?: any;
}

const clamp = (n: number, min = 0, max = 1) => Math.max(min, Math.min(max, n));

export const CustomDot: React.FC<Props> = ({ cx = 0, cy = 0, payload }) => {
  if (!payload) return null;

  const color = trendColorMap[payload.originalTrend as keyof typeof trendColorMap];
  const conf = clamp(payload.confidence ?? 0.5);
  const radius = 4 + conf * 6;
  const fillOpacity = 0.4 + conf * 0.6;

  return <circle cx={cx} cy={cy} r={radius} fill={color} fillOpacity={fillOpacity} />;
};
