"use client";

/**
 * 🧠 HUD Mock Reporter — Phase 9.3
 * Displays a translucent neon banner when the OS is running in
 * Mock / Test mode (Vitest, JSDOM, or manual dev simulation).
 */

import React, { useEffect, useState } from "react";
import { motion } from "framer-motion";

export const HUDMockReporter: React.FC = () => {
  const [active, setActive] = useState(false);
  const [env, setEnv] = useState("");

  useEffect(() => {
    // Detect Mock Environment conditions
    const isMock =
      typeof window !== "undefined" &&
      (window.location?.href?.includes("vitest") ||
        (window as any).__VITEST_GLOBALS__ ||
        (window as any).speechSynthesis?.getVoices?.toString?.().includes("Mock") ||
        localStorage.getItem("HUD_MOCK_ACTIVE") === "true");

    if (isMock) {
      setActive(true);
      localStorage.setItem("HUD_MOCK_ACTIVE", "true");
      setEnv(
        (window as any).__VITEST_GLOBALS__
          ? "Vitest"
          : window.location?.href?.includes("localhost")
          ? "Localhost"
          : "Mock Layer"
      );
    }
  }, []);

  if (!active) return null;

  return (
    <motion.div
      initial={{ opacity: 0, y: -10 }}
      animate={{ opacity: 1, y: 0 }}
      exit={{ opacity: 0, y: -10 }}
      transition={{ duration: 0.5, ease: "easeOut" }}
      style={{
        position: "fixed",
        top: 16,
        right: 16,
        zIndex: 2147483647,
        pointerEvents: "none",
      }}
    >
      <div
        className="px-4 py-2 rounded-xl border border-cyan-400/40 bg-[rgba(0,8,20,0.75)] backdrop-blur-md text-cyan-200 font-mono text-xs shadow-[0_0_15px_rgba(0,255,255,0.3)] animate-pulse"
      >
        🧩 Mock Mode Active — {env}
      </div>
    </motion.div>
  );
};
