"use client";

import { personalInfo, philosophy } from "@/data/apps";
import styles from "@/components/windows/WindowContent.module.css";
import { Mail, Phone, Linkedin, Github, Globe } from "lucide-react";

// 🧠 Debug toggle
const DEBUG =
  (typeof process !== "undefined" &&
    process.env.NODE_ENV !== "production") ||
  (typeof process !== "undefined" &&
    process.env.NEXT_PUBLIC_DEBUG === "true");

const dlog = (...args: any[]) => {
  if (DEBUG) console.log("[AboutContent]", ...args);
};

export default function AboutContent() {
  const safeInfo = personalInfo || {};
  const safePhilosophy = Array.isArray(philosophy) ? philosophy : [];

  dlog("🧱 Rendering AboutContent", {
    hasInfo: !!personalInfo,
    hasPhilosophy: safePhilosophy.length,
  });

  return (
    <div className={styles.windowContent}>
      {/* About Section */}
      <section className={styles.contentSection}>
        <h2>About Me</h2>
        <div className={styles.aboutGrid}>
          <div className={styles.profileColumn}>
            <img
              src={safeInfo.image || "/placeholder.svg?height=200&width=200"}
              alt={safeInfo.name || "Profile"}
              className={styles.profileImage}
              loading="lazy"
            />
          </div>
          <div className={styles.summaryColumn}>
            {safeInfo.summary ? (
              <p className={styles.summaryText}>{safeInfo.summary}</p>
            ) : (
              <p className={styles.summaryText}>
                Passionate developer with a love for building creative digital
                systems and mentoring teams.
              </p>
            )}
          </div>
        </div>
      </section>

      {/* Contact Info */}
      <section className={styles.contentSection}>
        <h2>Contact Information</h2>
        <ul className={styles.contactInfo}>
          {safeInfo.email && (
            <li>
              <Mail size={20} />
              <span>{safeInfo.email}</span>
            </li>
          )}
          {safeInfo.phone && (
            <li>
              <Phone size={20} />
              <span>{safeInfo.phone}</span>
            </li>
          )}
          {safeInfo.linkedin && (
            <li>
              <Linkedin size={20} />
              <a
                href={safeInfo.linkedin}
                target="_blank"
                rel="noopener noreferrer"
              >
                LinkedIn Profile
              </a>
            </li>
          )}
          {safeInfo.github && (
            <li>
              <Github size={20} />
              <a
                href={safeInfo.github}
                target="_blank"
                rel="noopener noreferrer"
              >
                GitHub Profile
              </a>
            </li>
          )}
          {safeInfo.portfolio && (
            <li>
              <Globe size={20} />
              <a
                href={safeInfo.portfolio}
                target="_blank"
                rel="noopener noreferrer"
              >
                Portfolio Website
              </a>
            </li>
          )}
        </ul>
      </section>

      {/* Philosophy Section */}
      <section className={styles.contentSection}>
        <h2>My Philosophy</h2>
        {safePhilosophy.length > 0 ? (
          <ul>
            {safePhilosophy.map((item, index) => (
              <li key={index}>{item}</li>
            ))}
          </ul>
        ) : (
          <p>No philosophy statements available at the moment.</p>
        )}
      </section>
    </div>
  );
}
