"use client"
import React from "react" // Import React
import styles from "./FolderContent.module.css"

const SkillsFolder: React.FC = () => { // Add React.FC type
  return (
    <div className={styles.folderContainer}>
      <h1 className={styles.folderTitle}>Technical Skills</h1>

      <div className={styles.skillsGrid}>
        <div className={styles.skillCategory}>
          <h2>Backend</h2>
          <ul className={styles.skillList}>
            <li>Laravel (4.3–12)</li>
            <li>PHP</li>
            <li>MySQL</li>
            <li>MongoDB</li>
            <li>RESTful APIs</li>
          </ul>
        </div>

        <div className={styles.skillCategory}>
          <h2>Architecture</h2>
          <ul className={styles.skillList}>
            <li>SOLID Principles</li>
            <li>Clean Code</li>
            <li>Queues & Notifications</li>
            <li>Task Scheduling</li>
            <li>Modular Monolith</li>
          </ul>
        </div>

        <div className={styles.skillCategory}>
          <h2>Frontend</h2>
          <ul className={styles.skillList}>
            <li>Vue.js</li>
            <li>TailwindCSS</li>
            <li>Blade Templates</li>
            <li>FullCalendar.js</li>
            <li>Bootstrap</li>
          </ul>
        </div>

        <div className={styles.skillCategory}>
          <h2>DevOps & Tools</h2>
          <ul className={styles.skillList}>
            <li>Git & Bitbucket</li>
            <li>WHM & cPanel</li>
            <li>Deployment & Git Hooks</li>
            <li>Server Management</li>
          </ul>
        </div>

        <div className={styles.skillCategory}>
          <h2>Payment & APIs</h2>
          <ul className={styles.skillList}>
            <li>Paymob</li>
            <li>MyFatoorah</li>
            <li>Shopify</li>
            <li>WhatsApp API</li>
            <li>Trello API</li>
          </ul>
        </div>

        <div className={styles.skillCategory}>
          <h2>Leadership & Soft Skills</h2>
          <ul className={styles.skillList}>
            <li>Agile Methodologies</li>
            <li>Team Leadership (3+ developers)</li>
            <li>Code Reviews</li>
            <li>Technical Documentation</li>
            <li>Cross-functional Collaboration</li>
          </ul>
        </div>
      </div>

      <div className={styles.specialization}>
        <h2>Specialization</h2>
        <p>
          Expert in Laravel (from 4.3 to 12) and Vue.js with API-driven architecture. Specialized in building scalable
          systems for CRM, education, and logistics domains. Known for balancing clean code, strategic planning, and
          people-focused development while leading cross-functional teams.
        </p>
      </div>
    </div>
  )
}

export default SkillsFolder; // Export as default