// tests/feedback/cooldown.spec.ts
import { describe, it, expect } from 'vitest';
import { canRun, mark } from '../../lib/feedback/cooldown';

describe('Cooldown Logic', () => {
  it('should allow first run', () => {
    const result = canRun('TEST', Date.now());
    expect(result).toBe(true);
  });

  it('should block repeated execution within cooldown', () => {
    const now = Date.now();
    mark('TEST', now, true);
    const blocked = canRun('TEST', now + 1000, 5000);
    expect(blocked).toBe(false);
  });

  it('should reset backoff after success', () => {
    const now = Date.now();
    mark('TASK', now, false); // فشل
    mark('TASK', now + 60_000, true); // نجاح بعد دقيقة
    const can = canRun('TASK', now + 130_000, 60_000); // بعد دقيقتين
    expect(can).toBe(true);
  });
});
